import argparse, json
from pathlib import Path
from sqlalchemy import create_engine, text

def upsert_listings(dsn: str, path: Path):
    engine = create_engine(dsn, pool_pre_ping=True)
    rows = [json.loads(line) for line in path.read_text().splitlines()]
    with engine.begin() as conn:
        for r in rows:
            conn.execute(
                text(
                    """
INSERT INTO listings (broker, listing_id, resort, unit, beds, baths, points, price, status, link, images, hash, last_seen_at)
VALUES (:broker,:listing_id,:resort,:unit,:beds,:baths,:points,:price,:status,:link,CAST(:images AS JSON),:hash, NOW())
ON DUPLICATE KEY UPDATE
  resort=VALUES(resort), unit=VALUES(unit), beds=VALUES(beds), baths=VALUES(baths),
  points=VALUES(points), price=VALUES(price), status=VALUES(status), link=VALUES(link),
  images=VALUES(images), hash=VALUES(hash), last_seen_at=NOW()
"""
                ),
                {
                    **r,
                    "images": json.dumps(r.get("images", [])),
                    "hash": r.get("hash", ""),
                },
            )

def main():
    ap = argparse.ArgumentParser()
    ap.add_argument("--dsn", required=True)
    ap.add_argument("--path", default="out/latest/combined.jsonl")
    args = ap.parse_args()
    upsert_listings(args.dsn, Path(args.path))

if __name__ == "__main__":
    main()
