from pathlib import Path
from typing import Any, Dict, List
import yaml

SITES_PATH = Path("config/sites.yaml")

def _load_sites() -> List[Dict[str, Any]]:
    if not SITES_PATH.exists():
        return []
    data = yaml.safe_load(SITES_PATH.read_text())
    return data or []

def list_brokers() -> List[str]:
    return [s["name"] for s in _load_sites()]

def get_tasks() -> List[Dict[str, Any]]:
    return _load_sites()
